<?php
// This file handles the print functionality
$print_candidates = array();

// Get the same filters as the main search
$filters = array_filter($_GET, function($key) { 
    return !in_array($key, ['print', 'success', 'error']); 
}, ARRAY_FILTER_USE_KEY);

if (!empty($filters)) {
    $candidates_stmt = $candidate->search($filters);
} else {
    $filterUserArr = [];
    if($role != 'admin'){
        $filterUserArr['created_by'] = $userId;
    }
    $candidates_stmt = $candidate->read($filterUserArr);
}

$print_candidates = $candidates_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Candidates - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        @media print {
            body { 
                background: white !important; 
                font-size: 12px;
            }
            .container { 
                max-width: 100% !important; 
                margin: 0 !important;
                padding: 0 !important;
            }
            .table { 
                font-size: 10px; 
                margin: 0;
            }
            .table th, .table td { 
                padding: 2px !important; 
                border: 1px solid #000 !important;
            }
            .table th {
                background-color: #f0f0f0 !important;
                font-weight: bold;
            }
            .page-break {
                page-break-after: always;
            }
            .no-print {
                display: none !important;
            }
        }
        
        .print-header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
        }
        
        .print-info {
            margin-bottom: 15px;
            font-size: 12px;
        }
        
        .status-badge {
            font-size: 0.7rem;
            padding: 2px 6px;
            border-radius: 8px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-pending { background-color: #fff3cd; color: #856404; }
        .status-shortlisted { background-color: #d4edda; color: #155724; }
        .status-selected { background-color: #d1ecf1; color: #0c5460; }
        .status-rejected { background-color: #f8d7da; color: #721c24; }
        .status-hold { background-color: #e2e3e5; color: #383d41; }
        .status-joined { background-color: #d1ecf1; color: #0c5460; }
        .status-rescheduled { background-color: #ffeaa7; color: #6c5ce7; }
        .status-process_ended { background-color: #fab1a0; color: #e17055; }
    </style>
</head>
<body onload="window.print()">
    <div class="container">
        <div class="print-header">
            <h2>Candidate Management System</h2>
            <h4>Candidates Report</h4>
        </div>
        
        <div class="print-info">
            <div class="row">
                <div class="col-6">
                    <strong>Generated on:</strong> <?php echo date('d-M-Y H:i:s'); ?>
                </div>
                <div class="col-6 text-end">
                    <strong>Total Records:</strong> <?php echo count($print_candidates); ?>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-12">
                    <strong>Generated by:</strong> <?php echo htmlspecialchars($_SESSION['username'] ?? 'System'); ?>
                </div>
            </div>
        </div>

        <?php if (empty($print_candidates)): ?>
            <div class="alert alert-info">
                No candidates found matching your search criteria.
            </div>
        <?php else: ?>
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <th style="width: 8%;">ID</th>
                        <th style="width: 15%;">Name</th>
                        <th style="width: 12%;">Phone</th>
                        <th style="width: 15%;">Email</th>
                        <th style="width: 10%;">Location</th>
                        <th style="width: 10%;">Team</th>
                        <th style="width: 8%;">Ref Code</th>
                        <th style="width: 8%;">Lineup Date</th>
                        <th style="width: 7%;">Source</th>
                        <th style="width: 7%;">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($print_candidates as $index => $cand): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($cand['candidate_id']); ?></td>
                            <td><?php echo htmlspecialchars($cand['name']); ?></td>
                            <td><?php echo htmlspecialchars($cand['phone']); ?></td>
                            <td style="font-size: 9px;"><?php echo htmlspecialchars($cand['email']); ?></td>
                            <td><?php echo htmlspecialchars($cand['location']); ?></td>
                            <td><?php echo htmlspecialchars($cand['team_name']); ?></td>
                            <td><?php echo htmlspecialchars($cand['referral_code'] ?? 'N/A'); ?></td>
                            <td><?php echo date('d-M-Y', strtotime($cand['lineup_date'])); ?></td>
                            <td><?php echo htmlspecialchars($cand['source_name']); ?></td>
                            <td>
                                <span class="status-badge status-<?php echo $cand['status']; ?>">
                                    <?php echo strtoupper($cand['status']); ?>
                                </span>
                            </td>
                        </tr>
                        <?php 
                        // Add page break every 25 records for better printing
                        if (($index + 1) % 25 == 0 && ($index + 1) < count($print_candidates)): 
                        ?>
                            </tbody>
                        </table>
                        <div class="page-break"></div>
                        <table class="table table-bordered table-sm">
                            <thead>
                                <tr>
                                    <th style="width: 8%;">ID</th>
                                    <th style="width: 15%;">Name</th>
                                    <th style="width: 12%;">Phone</th>
                                    <th style="width: 15%;">Email</th>
                                    <th style="width: 10%;">Location</th>
                                    <th style="width: 10%;">Team</th>
                                    <th style="width: 8%;">Ref Code</th>
                                    <th style="width: 8%;">Lineup Date</th>
                                    <th style="width: 7%;">Source</th>
                                    <th style="width: 7%;">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <!-- Summary Statistics for Print -->
            <div class="mt-4">
                <h5>Summary Statistics</h5>
                <table class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Count</th>
                            <th>Percentage</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $status_counts = array_count_values(array_column($print_candidates, 'status'));
                        $total = count($print_candidates);
                        
                        $status_labels = [
                            'pending' => 'Pending',
                            'shortlisted' => 'Shortlisted',
                            'selected' => 'Selected',
                            'rejected' => 'Rejected',
                            'hold' => 'On Hold',
                            'joined' => 'Joined',
                            'rescheduled' => 'Rescheduled',
                            'process_ended' => 'Process Ended'
                        ];
                        
                        foreach ($status_labels as $status => $label):
                            $count = $status_counts[$status] ?? 0;
                            $percentage = $total > 0 ? round(($count / $total) * 100, 1) : 0;
                            if ($count > 0):
                        ?>
                            <tr>
                                <td><?php echo $label; ?></td>
                                <td><?php echo $count; ?></td>
                                <td><?php echo $percentage; ?>%</td>
                            </tr>
                        <?php 
                            endif;
                        endforeach; 
                        ?>
                        <tr class="table-primary">
                            <td><strong>Total</strong></td>
                            <td><strong><?php echo $total; ?></strong></td>
                            <td><strong>100%</strong></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
        
        <div class="mt-4 text-center">
            <small>
                <em>This report was generated automatically by the Candidate Management System</em>
            </small>
        </div>
    </div>
</body>
</html>
