<?php
include_once 'config/database.php';
include_once 'classes/Candidate.php';

session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$database = new Database();
$db = $database->getConnection();
$candidate = new Candidate($db);

// Get statistics
$role = $_SESSION['role'] ?? null;
$userId = $_SESSION['user_id'] ?? null;

$filterUserArr = [];
if($role != 'admin'){
    $filterUserArr['created_by'] = $userId;
}

$all_candidates_stmt = $candidate->read($filterUserArr);
$all_candidates = $all_candidates_stmt->fetchAll(PDO::FETCH_ASSOC);

$total_candidates = count($all_candidates);
$status_counts = array_count_values(array_column($all_candidates, 'status'));

// Get recent candidates
$recent_candidates = array_slice($all_candidates, 0, 5);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Candidate Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .navbar { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .stat-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 25px;
            margin-bottom: 20px;
            transition: transform 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .stat-number {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .recent-candidates {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 25px;
        }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">
                <i class="fas fa-users me-2"></i>
                Candidate Management System
            </a>
            <div class="navbar-nav ms-auto">
                <span class="navbar-text me-3">
                    Welcome, <?php echo htmlspecialchars($_SESSION['username']); ?>
                </span>
                <a href="logout.php" class="btn btn-outline-light btn-sm">
                    <i class="fas fa-sign-out-alt me-1"></i>Logout
                </a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <h2 class="mb-4">Dashboard Overview</h2>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row">
            <div class="col-md-3">
                <div class="stat-card text-center">
                    <div class="stat-number text-primary"><?php echo $total_candidates; ?></div>
                    <h6>Total Candidates</h6>
                    <i class="fas fa-users fa-2x text-primary opacity-25"></i>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card text-center">
                    <div class="stat-number text-warning"><?php echo $status_counts['pending'] ?? 0; ?></div>
                    <h6>Pending</h6>
                    <i class="fas fa-clock fa-2x text-warning opacity-25"></i>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card text-center">
                    <div class="stat-number text-info"><?php echo $status_counts['shortlisted'] ?? 0; ?></div>
                    <h6>Shortlisted</h6>
                    <i class="fas fa-list fa-2x text-info opacity-25"></i>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card text-center">
                    <div class="stat-number text-success"><?php echo ($status_counts['selected'] ?? 0) + ($status_counts['joined'] ?? 0); ?></div>
                    <h6>Selected/Joined</h6>
                    <i class="fas fa-check-circle fa-2x text-success opacity-25"></i>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="stat-card">
                    <h5 class="mb-3"><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <a href="add-candidate.php" class="btn btn-primary w-100">
                                <i class="fas fa-plus me-2"></i>Add New Candidate
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="search-candidates.php" class="btn btn-info w-100">
                                <i class="fas fa-search me-2"></i>Search Candidates
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="search-candidates.php?show_all=1" class="btn btn-success w-100">
                                <i class="fas fa-list me-2"></i>View All Candidates
                            </a>
                        </div>
                        <div class="col-md-3 mb-2">
                            <a href="reports.php" class="btn btn-warning w-100">
                                <i class="fas fa-chart-bar me-2"></i>Reports
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Candidates -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="recent-candidates">
                    <h5 class="mb-3"><i class="fas fa-history me-2"></i>Recent Candidates</h5>
                    <?php if (empty($recent_candidates)): ?>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>No candidates found. <a href="add-candidate.php">Add your first candidate</a>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Added Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_candidates as $cand): ?>
                                        <tr>
                                            <td><strong><?php echo $cand['candidate_id']; ?></strong></td>
                                            <td><?php echo htmlspecialchars($cand['name']); ?></td>
                                            <td><?php echo htmlspecialchars($cand['email']); ?></td>
                                            <td>
                                                <span class="badge bg-<?php 
                                                    echo match($cand['status']) {
                                                        'pending' => 'warning',
                                                        'shortlisted' => 'info',
                                                        'selected' => 'success',
                                                        'joined' => 'success',
                                                        'rejected' => 'danger',
                                                        'hold' => 'secondary',
                                                        'rescheduled' => 'primary',
                                                        default => 'secondary'
                                                    };
                                                ?>">
                                                    <?php echo strtoupper($cand['status']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo date('d-M-Y', strtotime($cand['added_date'])); ?></td>
                                            <td>
                                                <a href="search-candidates.php?candidate_id=<?php echo $cand['candidate_id']; ?>" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
